local Screen = require "widgets.screen"
local Text = require "widgets.text"
local easing = require "util.easing"
local templates = require "widgets.ftf.templates"
local Image = require "widgets.image"
local Widget = require("widgets/widget")
local krandom = require("util.krandom")

local CreditsScreen = Class(Screen, function(self, player)
	Screen._ctor(self, "CreditsScreen")

	-- Add background
	self.bg = self:AddChild(templates.BackgroundImage("images/ui_ftf_pausescreen/background_gradient.tex"))
	self.container = self:AddChild(Image("images/bg_popup_flat/popup_flat.tex"))
		:SetScale(1.125, 1.125)

	self.fmod_page = self.container:AddChild(Widget("FMOD Credits"))
	self.fmod_logo = self.fmod_page:AddChild(Image("images/icons_other/fmod_logo_white.tex"))
		:LayoutBounds("center", "center", self.container)
		:SetMultColor(UICOLORS.LIGHT_TEXT_DARK)
		:SetScale(0.75)
		:Offset(-400, 0)
	self.fmod_str = self.fmod_page:AddChild(Text(FONTFACE.DEFAULT, 92))
		:LeftAlign()
		:SetText(STRINGS.CREDITS.FMOD)
		:LayoutBounds("after", "center", self.fmod_logo)
		:SetGlyphColor(UICOLORS.LIGHT_TEXT_DARK)
		:Offset(40, 0)
	self.fmod_page:Hide()

	self.huwiz_page = self.container:AddChild(Widget("Huwiz Credits"))
	self.huwiz_str = self.huwiz_page:AddChild(Text(FONTFACE.DEFAULT, 92))
		:LeftAlign()
		:LayoutBounds("center", "top", self.container)
		:SetText(STRINGS.CREDITS.QA_BY)
		:SetGlyphColor(UICOLORS.LIGHT_TEXT_DARK)
		:Offset(-200, -145)

	self.huwiz_logo = self.huwiz_page:AddChild(Image("images/icons_other/huwiz_logo.tex"))
		:SetScale(0.4)
		:LayoutBounds("after", "center", self.huwiz_str)
		:Offset(25, 0)
	self.huwiz_page:Hide()

	self.credits_page = self.container:AddChild(Widget("Klei Credits"))
	self.title = self.credits_page:AddChild(Text(FONTFACE.DEFAULT, 108))
		:LeftAlign()
		:LayoutBounds("center", "top", self.container)
		:Offset(0, -150)
		:SetGlyphColor(UICOLORS.LIGHT_TEXT_DARK)
		:SetText(STRINGS.UI.CREDITSSCREEN.TITLE)

	self.title_decor_left = self.credits_page:AddChild(Image("images/ui_ftf_inventory/InventoryTitleDecorLeft.tex"))
		:SetSize(80, 80)
		:SetMultColor(UICOLORS.LIGHT_TEXT_DARK)
		:SetMultColorAlpha(0.5)
		:LayoutBounds("before", "center", self.title)
		:SetScale(1.2, 1.2)
		:Offset(-20, 0)

	self.title_decor_right = self.credits_page:AddChild(Image("images/ui_ftf_inventory/InventoryTitleDecorRight.tex"))
		:SetSize(80, 80)
		:SetMultColor(UICOLORS.LIGHT_TEXT_DARK)
		:SetMultColorAlpha(0.5)
		:LayoutBounds("after", "center", self.title)
		:SetScale(1.2, 1.2)
		:Offset(20, 0)

	self.names_per_column = 15
	self:GenerateCredits("KLEI", true, self.credits_page)
	self:GenerateCredits("QA", false, self.huwiz_page)

	self.pages =
	{
		self.credits_page,
		self.huwiz_page,
		self.fmod_page,
	}

	-- Back button
	self.button = self:AddChild(templates.Button(STRINGS.UI.BUTTONS.NEXT))
		:SetPrimary()
		:LayoutBounds("center", "bottom", self.bg)
		:Offset(30, 20)
		:SetSize(BUTTON_W - (50 * HACK_FOR_4K), BUTTON_H)

	self.button:SetOnClick(function()
		local old_page = self.current_page
		self.current_page = self.current_page + 1
		
		if self.current_page == #self.pages then
			self.button:SetText(STRINGS.UI.BUTTONS.CLOSE)
		end

		if self.current_page > #self.pages then
			TheFrontEnd:PopScreen(self)
		else
			self.pages[old_page]:Hide()
			self.pages[self.current_page]:Show()
		end
	end)

	self.default_focus = self.button
	self.current_page = 1
	self.credit_names = self.container:AddChild(Widget("Credit names"))
		:LayoutBounds("left", "top", self.container)
end)

CreditsScreen.CONTROL_MAP = 
{
	{
		control = Controls.Digital.CANCEL,
		hint = function(self, left, right)
			table.insert(right, loc.format(LOC"UI.CONTROLS.CANCEL", Controls.Digital.CANCEL))
		end,
		fn = function(self)
			TheFrontEnd:PopScreen(self)
			return true
		end,
	},
}

function CreditsScreen:GenerateCredits(key, shuffle, names_parent)
	local credit_names = names_parent:AddChild(Widget("Names"))

	local names = shallowcopy(STRINGS.CREDITS[key])

	if shuffle then
		names = krandom.Shuffle(names)
	end

	local count = 0
	local credits_column = credit_names:AddChild(Widget("Credits Column"))
	for i, name in ipairs(names) do
		if count == self.names_per_column then
			credits_column:LayoutChildrenInColumn(18, "left")
			credits_column = credit_names:AddChild(Widget("Credits Column"))
			count = 0
		end

		credits_column:AddChild(Text(FONTFACE.BODYTEXT, 68))
			:SetText(name)
			:SetGlyphColor(UICOLORS.LIGHT_TEXT_DARK)

		count = count + 1
	end
	credits_column:LayoutChildrenInColumn(20, "left")

	credit_names
		:LayoutChildrenInRow(150, "left")
		:MoveToFront()
		:LayoutBounds("center", "top", self.container)
		:Offset(0, -220)
end


return CreditsScreen
